package com.ejie.aa94a.model.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.springframework.util.StringUtils;

import com.ejie.aa94a.model.calculo.Estiba;
import com.ejie.aa94a.model.calculo.Mensaje;

public class Configuracion implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	// Tipos de Vehículo
	public static List<Vehiculo> vehiculos;
	// Tipos de Sujeción
	public static List<TipoSujecion> tiposSujecion;
	// Densidades de los materiales
	public static List<Densidad> densidades;
	// Tipos de distancia
	public static List<TipoDistancia> tiposDistancia;
	// Estibas
	public static List<Estiba> estibas;
	// Mensajes de validación
	public static List<Mensaje> mensajes;
	// Rangos para las bobinas
	public static Carga bobina;
	// Rangos para los flejes
	public static Carga fleje;
	// Soluciones para el calculador
	public static List<Vehiculo> soluciones;

	private static HashMap<String, Estiba> hashMapEstibas;
	private static HashMap<String, Densidad> hashMapDensidades;
	private static HashMap<String, Mensaje> hashMapMensajes;
	private static HashMap<String, TipoDistancia> hashMapTiposDistancia;

	/**
	 * 
	 */
	private Configuracion() {
	}

	public static void initHashMap() {
		Configuracion.hashMapDensidades = new HashMap<String, Densidad>();
		Configuracion.hashMapEstibas = new HashMap<String, Estiba>();
		Configuracion.hashMapMensajes = new HashMap<String, Mensaje>();
		Configuracion.hashMapTiposDistancia = new HashMap<String, TipoDistancia>();
		if (Configuracion.estibas != null) {
			Iterator<Estiba> itEstibas = Configuracion.estibas.iterator();
			Estiba estiba = null;
			while (itEstibas.hasNext()) {
				estiba = itEstibas.next();
				Configuracion.hashMapEstibas.put(
						String.valueOf(estiba.getCodigo()), estiba);
			}
		}
		if (Configuracion.tiposDistancia != null) {
			Iterator<TipoDistancia> itTipoDistancia = Configuracion.tiposDistancia
					.iterator();
			TipoDistancia tipoDistancia = null;
			while (itTipoDistancia.hasNext()) {
				tipoDistancia = itTipoDistancia.next();
				Configuracion.hashMapTiposDistancia.put(
						String.valueOf(tipoDistancia.getCodigo()),
						tipoDistancia);
			}
		}
		if (Configuracion.mensajes != null) {
			Iterator<Mensaje> itMensajes = Configuracion.mensajes.iterator();
			Mensaje mensaje = null;
			while (itMensajes.hasNext()) {
				mensaje = itMensajes.next();
				Configuracion.hashMapMensajes.put(
						String.valueOf(mensaje.getCodigo()), mensaje);
			}
		}
		if (Configuracion.densidades != null) {
			Iterator<Densidad> itDensidades = Configuracion.densidades
					.iterator();
			Densidad densidad = null;
			while (itDensidades.hasNext()) {
				densidad = itDensidades.next();
				Configuracion.hashMapDensidades.put(
						String.valueOf(densidad.getCodigo()), densidad);
			}
		}
	}

	/**
	 * Obtiene la estiba del codigo asociado
	 * 
	 * @param codigo
	 * @return Estiba
	 */
	public static Estiba getEstiba(String codigo) {
		return Configuracion.hashMapEstibas.get(StringUtils
				.trimAllWhitespace(codigo));
	}

	/**
	 * Obtiene el mensaje del codigo asociado
	 * 
	 * @param codigo
	 * @return Mensaje
	 */
	public static Mensaje getMensaje(String codigo) {
		return Configuracion.hashMapMensajes.get(StringUtils
				.trimAllWhitespace(codigo));
	}

	/**
	 * Obtiene la densidad del codigo asociado
	 * 
	 * @param codigo
	 * @return Densidad
	 */
	public static Densidad getDensidad(String codigo) {
		return Configuracion.hashMapDensidades.get(StringUtils
				.trimAllWhitespace(codigo));
	}

	/**
	 * Obtiene el Tipo de distancia del codigo asociado
	 * 
	 * @param codigo
	 * @return TipoDistancia
	 */
	public static TipoDistancia getTipoDistancia(String codigo) {
		return Configuracion.hashMapTiposDistancia.get(StringUtils
				.trimAllWhitespace(codigo));
	}

	/**
	 * Obtiene el Vehiculo
	 * 
	 * @param codigo
	 *            Integer
	 * @return Vehiculo
	 */
	public static Vehiculo getVehiculo(Integer codigo) {
		List<Vehiculo> listaVehiculos = Configuracion.vehiculos;
		Vehiculo vehiculo = null;
		if (listaVehiculos != null) {
			Iterator<Vehiculo> itVehiculos = listaVehiculos.iterator();
			Vehiculo vehiculoAux = null;
			while (itVehiculos.hasNext()) {
				vehiculoAux = itVehiculos.next();
				if (vehiculoAux.getCodigo().equals(codigo)) {
					vehiculo = vehiculoAux;
					break;
				}
			}
		}
		return vehiculo;
	}

	/**
	 * Obtiene el TipoSujecion
	 * 
	 * @param codigo
	 *            Integer
	 * @return TipoSujecion
	 */
	public static TipoSujecion getTipoSujecion(Integer codigo) {
		List<TipoSujecion> listaTipoSujecion = Configuracion.tiposSujecion;
		TipoSujecion tipoSujecion = null;
		if (listaTipoSujecion != null) {
			Iterator<TipoSujecion> itTipoSujecion = listaTipoSujecion
					.iterator();
			TipoSujecion tipoSujecionAux = null;
			while (itTipoSujecion.hasNext()) {
				tipoSujecionAux = itTipoSujecion.next();
				if (tipoSujecionAux.getCodigo().equals(codigo)) {
					tipoSujecion = tipoSujecionAux;
					break;
				}
			}
		}
		return tipoSujecion;
	}

}
